#ifndef __DM_DEVICE_H__
#define __DM_DEVICE_H__

#include "dm_nutypedefs.h"
#include "dm_string_utils.h"

#ifdef __cplusplus
extern "C" {
#endif

// return codes for device functions
typedef enum
{
    DEVICE_ERROR = -1,
    DEVICE_OUTPUT_NONE = 0,
    DEVICE_OUTPUT_RAW = 1,
    DEVICE_OUTPUT_ASCII = 2
} DEVOUTPUT;

// user may use codes > 255
// add "presets" to this?
typedef enum
{
    DEVICE_INIT = 0,        // initialize the device
    DEVICE_PRINT = 1,       // print something out about the device
    DEVICE_TX = 2,          // send some data
    DEVICE_RX = 3,          // receive some data
    DEVICE_SET_DEBUG = 4,   // set the current debug level
    DEVICE_GET_DEBUG = 5,   // retrieve the current debug level
    DEVICE_LOAD = 6,        // load some firmware or fpga or other data
    DEVICE_SET = 7,         // change something on the device
    DEVICE_GET = 8,         // query something about the device
    DEVICE_DETECT = 9,      // try to read something from device to tell if it's really there and alive
    DEVICE_SELFTEST = 10,   // perform some self-diagnostics
    DEVICE_TRACE_ON = 11,   // for primitive data tracing / logging
    DEVICE_TRACE_OFF = 12,  // for primitive data tracing / logging
    DEVICE_ERASE = 13,
    DEVICE_SYNTAX = 14,
    DEVICE_ENABLE = 15,     // enable the device
    DEVICE_DISABLE = 16,     // disablet the device
    DEVICE_HALT = 17,
    DEVICE_RESET,
    DEVICE_DUMP
} DEVCMD;

#define DEV_CMD_USERBASE    256

////////////////////////////////////////////////////////////////////////////////

typedef INT32 (*DEVFUNC)(UINT32 inst, UINT32 type, UINT8 * pData, UINT32 * dataBytes);

////////////////////////////////////////////////////////////////////////////////

typedef struct
{
    UINT32 id;
    DEVFUNC pfDevEntryPt;
    UINT32 param;
    STRNUMPAIR * pStrNums;
}DEVINFO;

////////////////////////////////////////////////////////////////////////////////

extern void DevicesInit(void);
extern void DeviceRegister(UINT32 deviceId, DEVFUNC pfDevEntryPt, UINT32 param);
extern INT32 DeviceProcessInput(UINT32 inst, UINT32 device, UINT32 type, UINT8 * pData, UINT32 *pDataBytes);

extern void MyDevicesInit(void);
extern void DevicesPrepare(UINT32 maxDevices, UINT8* pData);
extern INT32 DeviceCmd(UINT32 ignore, char * cmd);

#ifdef __cplusplus
}
#endif

#endif  //__DM_DEVICE_H__

